#ifndef __CXYPad__
#define __CXYPad__

#include "CControl.hpp"
#include "CRolloverButton.hpp"
#include <MathTools/CBounds.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Controls::CRolloverButton;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CXYPad CXYPad.hpp
			 * @brief Control capable of movement in two dimensions
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @version 1.0.1 Added jump to position for mouse down
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CXYPad.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CXYPad : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CXYPad(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CXYPad();

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle a double click on the left button
				 * @param event The event to handle
				 */
				virtual void handleDoubleClick(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

				/**
				 * Get the x value
				 * @retval double x position value in range 0 - 1
				 */
				virtual double getXValue() { return m_xValue; }

				/**
				 * Get the y value
				 * @retval double y position value in range 0 - 1
				 */
				virtual double getYValue() { return m_yValue; }

//	===========================================================================

				/**
				 * Set the x value
				 * @param xValue The x position value in range  0 - 1
				 */
				virtual void setXValue(const double xValue);

				/**
				 * Set the y value
				 * @param yValue The y position value in range  0 - 1
				 */
				virtual void setYValue(const double yValue);

				/**
				 * Set the handle images
				 * @param handleImage The image of the area that can be grabbed by the user
				 * @param rolloverHandleImage The image of the area that can be grabbed by the user when mouse is over
				 * @param downHandleImage The image of the area that can be grabbed by the user when mouse is grabbing it
				 */
				virtual void setHandleImage(IImage *handleImage, IImage *rolloverHandleImage, IImage *downHandleImage);

				/**
				 * Set the colours
				 * @param frameColour The colour of the frame
				 * @param backgroundColour The background colour of the control
				 * @param handleColour The colour of the area that can be grabbed by the user
				 * @param handleOverColour The colour of the area that can be grabbed by the user when mouse is over
				 * @param handleDownColour The colour of the area that can be grabbed by the user when mouse is grabbing it
				 */
				virtual void setColours(CAlphaColour frameColour, CAlphaColour backgroundColour, CAlphaColour handleColour, CAlphaColour handleOverColour, CAlphaColour handleDownColour);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Check if the area is rolled over and lock if so
				 * @param point The point to check
				 */
				virtual void checkAndLock(const CPoint &point);

//	===========================================================================

				CRect m_handleArea;							/**< The hnadle area */
				CPoint m_grabOffset;						/**< What is the offset to where they grabbed? */
				CRolloverButton::ERolloverState m_state;	/**< Current state of slider (0 = off : 1 = over : 2 = on) */

				bool m_isDragging;							/**< Are we dragging the slider */
				double m_verticalRange;						/**< The range of the vertical handle */
				double m_horizontalRange;					/**< The range of the horizontal handle */

				double m_xValue;							/**< x value */
				double m_yValue;							/**< y value */

				IImage *m_handleImage;						/**< The handle image */
				IImage *m_handleRolloverImage;				/**< The rolled over image */
				IImage *m_handleDownImage;					/**< The down image */

				CAlphaColour m_handleColour;				/**< The colour of the handle */
				CAlphaColour m_handleOverColour;			/**< The colour of the handle when mouse is over */
				CAlphaColour m_handleDownColour;			/**< The colour of the handle when mouse is down */
			};
		}
	}
}
#endif	// End of CXYPad.hpp